package com.hero.objects.powers;

import java.util.ArrayList;
import java.util.Collections;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class LifeSupport extends Power {

	private static String xmlID = "LIFESUPPORT";

	public LifeSupport(Element root) {
		super(root, LifeSupport.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();
			ret += ")";
		}
		ArrayList<Adder> assigned = getAssignedAdders();
		Collections.sort(assigned);
		String adderString = "";
		for (Adder ad : getAssignedAdders()) {
			if (ad.displayInString() && ad.isSelected()
					&& (ad.getColumn2Output().trim().length() > 0)) {
				if (adderString.trim().length() > 0) {
					adderString += "; ";
				}
				adderString += ad.getColumn2Output();
			}
		}
		if (adderString.trim().length() > 0) {
			ret += " (" + adderString + ")";
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		return "";
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("EXTENDEDBREATHING")) {
				if (ad.getBaseCost() > 0) {
					String match = "" + Rounder.roundDown(ad.getBaseCost());
					ad.setLevels(0);
					for (int j = 0; j < ad.getOptions().size(); j++) {
						Adder op = ad.getOptions().get(j);
						if (op.getXMLID().equals(match)) {
							ad.setSelectedOption(op);
						}
					}
				}
			}
		}
	}
}